DROP PROCEDURE [hips].[PatientMasterContactInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 18 Oct 2012
-- Description:   Inserts a record into the Patien Master Contact Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterContactInsert] 
(
	@PatientMasterId INT,
	@ContactId INT,
	@UserModified varchar(256)
)
AS
BEGIN
	SET NOCOUNT ON

    DECLARE @intErrorCode int

    SET @intErrorCode = 0

	INSERT INTO hips.PatientMasterContact
	        ( PatientMasterId ,
	          ContactId ,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	        )
	VALUES  (	@PatientMasterId,
				@ContactId,
				GETDATE(),
				@UserModified,
				GETDATE(),
				@UserModified
	
	        )
	SELECT @intErrorCode = @@ERROR 
    IF @intErrorCode = 0
    BEGIN
        SELECT PatientMasterId,
                ContactId,
                [DateCreated],
                [UserCreated],
                [DateModified],
                [UserModified]
         FROM [hips].[PatientMasterContact]
         WHERE [PatientMasterId] = @PatientMasterId
         AND [ContactId] = @ContactId
    END

    RETURN(@intErrorCode)


END
GO

